package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.network.Handler18TPEffects;

import java.util.Random;

import net.minecraft.entity.CCEntityAnything;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class GeneTeleport extends Gene{

	@Override
	public String getName() {
		return "Teleport";
	}

	@Override
	public int getMaxAmount() {
		return 1;
	}

	@Override
	public String getStringValue(int amount) {
		return "Teleport";
	}

	@Override
	public int getColour() {
		return 0xff331133;
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{EntityEnderman.class, EntityDragon.class};
	}

	static Random rand = new Random();

	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		if(!(entity instanceof EntityPlayer)){
			EntityLiving living = null;
			if(entity instanceof CCEntityAnything){
				living = ((CCEntityAnything)entity).theEntity;
			}else if(entity instanceof EntityLiving){
				living = (EntityLiving)entity;
			}

			if(living != null && !living.getNavigator().noPath()){
				if(rand.nextInt(living.getAttackTarget() != null?30:60) == 0){
					PathEntity path = living.getNavigator().getPath();
					if(path != null){
						PathPoint point = path.getFinalPathPoint();
						if(point != null){
							int bx = (int)entity.posX;
							int by = (int)entity.posY;
							int bz = (int)entity.posZ;
							int fx = point.xCoord;
							int fy = point.yCoord;
							int fz = point.zCoord;


							int dx = (int)Math.floor((fx-bx) * 0.8 + bx);
							int dy = (int)Math.floor((fy-by) * 0.8 + by);
							int dz = (int)Math.floor((fz-bz) * 0.8 + bz);

							Vec3 tpTo = getClosestValidTPCoord(dx, dy, dz, entity);
							
							/*Vec3 mid = Vec3.createVectorHelper(dx, dy, dz);

							Vec3 tpTo = null;

							Vec3 temp = null;

							double distance = 1000;
							for(int x = 0; x < 3; x++){
								for(int z = 0; z < 3; z++){
									int pX = dx-2+x;
									int pZ = dz-2+z;
									int topBlock = entity.worldObj.getTopSolidOrLiquidBlock(pX, pZ);

									if((temp = Vec3.createVectorHelper(pX, topBlock, pZ)).distanceTo(mid) < distance){
										tpTo = temp;
									}
								}
							}*/

							if(tpTo != null){
								living.setPosition(tpTo.xCoord + 0.5f, tpTo.yCoord, tpTo.zCoord + 0.5f);
								new Handler18TPEffects(bx, by, bz, tpTo.xCoord, tpTo.yCoord,tpTo.zCoord, living).sendToAllWatching(living);
							}


							/*makeEffects(living, living.worldObj, tpTo);
							makeEffects(living, living.worldObj, Vec3.createVectorHelper(bx, by, bz));
							System.out.println("TELEPORT!");*/
						}
					}
				}

			}
		}


	}
	
	public static Vec3 getClosestValidTPCoord(int dx, int dy, int dz, EntityLivingBase entity){
		Vec3 mid = Vec3.createVectorHelper(dx, dy, dz);
		
		Vec3 tpTo = null;

		Vec3 temp = null;

		double distance = 1000;
		double tempDistance;
		for(int x = 0; x < 3; x++){
			for(int z = 0; z < 3; z++){
				int pX = dx-2+x;
				int pZ = dz-2+z;
				int topBlock = getValidTopBlock(entity.worldObj, pX, dy, pZ);//entity.worldObj.getTopSolidOrLiquidBlock(pX, pZ);

				
				
				if((tempDistance = (temp = Vec3.createVectorHelper(pX, topBlock, pZ)).distanceTo(mid)) < distance){
					tpTo = temp;
					distance = tempDistance;
				}
			}
		}
		return tpTo;
	}

	public static void makeTPEffects(EntityLivingBase e, double xf, double yf, double zf, double xt, double yt, double zt){
//		System.out.println("TP EFFECT");
		float f, f1, f2;

		double x, y, z;
		for(int a = 0; a < 2; a++){
			double tx = a==0?xf:xt;
			double ty = a==0?yf:yt;
			double tz = a==0?zf:zt;
			for(int b = 0; b < 128; b++){
				f = (rand.nextFloat() - 0.5F) * 0.2F;
				f1 = (rand.nextFloat() - 0.5F) * 0.2F;
				f2 = (rand.nextFloat() - 0.5F) * 0.2F;

				x = tx + (rand.nextFloat() - 0.5F) * (double)e.width * 2.0D;
				y = ty + rand.nextDouble() * (double)e.height;
				z = tz + (rand.nextFloat() - 0.5F) * (double)e.width * 2.0D;

				e.worldObj.spawnParticle("portal", x, y, z, f, f1, f2);
				
			}
			e.worldObj.playSound(xf, yf, zf, "mob.endermen.portal", 1.0f, 1.0f, true);
		}
	}
	
	public static int getValidTopBlock(World world, int x, int y, int z){
		for(int a = y; a < 256; a++){
			if(isBlockAir(x, a, z, world)){
				if(isBlockAir(x, a+1, z, world)){
					return a;
				}
			}
		}
		return 256;
	}
	
	public static boolean isBlockAir(int x, int y, int z, World world){
		if(y > 255){
			return true;
		}
		return world.getBlockId(x, y, z) == 0;
	}
	
	public static int getMaxTPDistance(){
		return 128;
	}
	public static int getMaxTPDistanceSqrd(){
		return 16384;
	}


	/*public static void makeEffects(EntityLivingBase e, World world, Vec3 pos){
		short short1 = 128;

		for (int l = 0; l < short1; ++l)
		{
			double d6 = (double)l / ((double)short1 - 1.0D);
			float f = (rand.nextFloat() - 0.5F) * 0.2F;
			float f1 = (rand.nextFloat() - 0.5F) * 0.2F;
			float f2 = (rand.nextFloat() - 0.5F) * 0.2F;
			double d7 = pos.xCoord + (rand.nextDouble() - 0.5D) * (double)e.width * 2.0D;
			double d8 = pos.yCoord + rand.nextDouble() * (double)e.height;
			double d9 = pos.zCoord + (rand.nextDouble() - 0.5D) * (double)e.width * 2.0D;
			world.spawnParticle("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
		}

		world.playSoundEffect(pos.xCoord, pos.yCoord, pos.zCoord, "mob.endermen.portal", 1.0F, 1.0F);
		e.playSound("mob.endermen.portal", 1.0F, 1.0F);
	}*/

	@Override
	public void addGeneEffect(EntityLivingBase entity, int level) {
	}

	public GeneTeleport(int id) {
		super(id);
		// TODO Auto-generated constructor stub
	}

}
